IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CPJ_Item_Paid_On_Date') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.CPJ_Item_Paid_On_Date
END
GO

CREATE PROCEDURE dbo.CPJ_Item_Paid_On_Date @pJSon	VARCHAR(8000)
AS
SET NOCOUNT ON 

/*Variables recibidas por parmetro a traves del JSON*/
DECLARE	@pFlagUsarTrans			TINYINT
DECLARE @pModoDebug				TINYINT
DECLARE @pId_Cliente			INT
DECLARE @pId_Productos			VARCHAR(7900)
DECLARE @pFecha					DATETIME

SET @pFlagUsarTrans				= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'FlagUsarTrans')), 0)
SET @pModoDebug					= ISNULL(CONVERT(TINYINT, dbo.CF_JSON_VALUE(@pJson,'ModoDebug')), 0)
SET @pId_Cliente				= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)
SET @pId_Productos				= ISNULL(CONVERT(VARCHAR(7900), dbo.CF_JSON_VALUE(@pJson,'Id_Productos')), 0) /**/
SET @pFecha						= ISNULL(CONVERT(DATETIME, dbo.CF_JSON_VALUE(@pJson,'Fecha')), 0)
/*FIN Variables recibidas por parmetro a traves del JSON*/

/*Declaracion Variables Locales*/
DECLARE	@rtaMsjStored						VARCHAR(100)
DECLARE @SqlStr								NVARCHAR(MAX)
DECLARE @SqlStrNotNull						NVARCHAR(MAX)
DECLARE @Parametros							NVARCHAR(100)
DECLARE @Id_Producto						VARCHAR(14)
DECLARE @Flag_Item_Pagado					TINYINT
DECLARE @Fecha_DATE							DATE
DECLARE @Fecha_DATE_VARCHAR					VARCHAR(8)
DECLARE @posicion							INT
DECLARE @longitud							INT
DECLARE @Cada_Id_Producto					VARCHAR(14)
DECLARE @Lista_Id_Productos					VARCHAR(7900)
/*Fin de Declaraciones Variables Locales */


BEGIN TRY

	IF @pFlagUsarTrans <> 0 
	BEGIN
		BEGIN TRAN
	END

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Ingreso a Stored Procedure: CPJ_Item_Paid_On_Date'
		PRINT 'Parametros:'
		PRINT 'pJSon: ' + CONVERT(VARCHAR(8000), @pJSon)		
	END
	
	/*===================================================================*/
	
	SET @Fecha_DATE			=	CONVERT(DATE, @pFecha)
	
	SET @Fecha_DATE_VARCHAR =	CONVERT(VARCHAR(4), DATEPART(YEAR, @Fecha_DATE))	+ 
								RIGHT('00' + CAST(DATEPART(MONTH, @Fecha_DATE) AS VARCHAR), 2) +
								RIGHT('00' + CAST(DATEPART(DAY, @Fecha_DATE) AS VARCHAR), 2)
	
	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fecha_DATE_VARCHAR: ' + @Fecha_DATE_VARCHAR
	END
	
	/*===================================================================*/
	
	SET @pId_Productos = LTRIM(RTRIM(@pId_Productos))
	
	IF(@pModoDebug = 1)
	BEGIN	
		PRINT 'pId_Productos: ' + @pId_Productos
	END
	
	IF(LEN(@pId_Productos) = 0)
	BEGIN
		/*No mandaron ningun Producto a validar, Sale del Stored*/
		SET @rtaMsjStored		=	'{' +
									dbo.CF_Json_ParsearVariable('Flag_Item_Pagado', 0, 'TINYINT') +
									'}'

		SELECT	 0				AS ErrorNumber 
				,0				AS ErrorSeverity  
				,0				AS ErrorState 
				,0				AS ErrorProcedure  
				,0				AS ErrorLine		
				,@rtaMsjStored	AS ErrorMessage
				
		RETURN 0
	END
	
	IF (SUBSTRING(@pId_Productos, LEN(@pId_Productos)-1, 1) <> ',')
	BEGIN
		SET @pId_Productos = @pId_Productos + ','
	END
	
	SET @posicion = 0
	SET @longitud = 0
	SET @Lista_Id_Productos = ''
	
	WHILE CHARINDEX(',', @pId_Productos, @posicion + 1) > 0
	BEGIN
		SET @longitud			= CHARINDEX(',', @pId_Productos, @posicion + 1) - @posicion
		SET @Cada_Id_Producto	= SUBSTRING(@pId_Productos, @posicion, @longitud)
		
		
		IF(@Lista_Id_Productos = '')
		BEGIN
			SET @Lista_Id_Productos = '''' + @Cada_Id_Producto + ''''
		END
		ELSE
		BEGIN
			SET @Lista_Id_Productos = LTRIM(RTRIM(@Lista_Id_Productos)) + ',''' + @Cada_Id_Producto + ''''
		END
		
		SET @posicion = CHARINDEX(',', @pId_Productos, @posicion + @longitud) +1
	END
	
	IF (@pModoDebug = 1)
	BEGIN	
		PRINT 'Lista_Id_Productos: ' + @Lista_Id_Productos
	END
	
	/*===================================================================*/
	
	SET @Flag_Item_Pagado = 0
	
	/*===================================================================*/
	
	SET @Parametros = N'@Id_ProductoOUT VARCHAR(14) OUTPUT'; 
	
	/*===================================================================*/
	
	SET @SqlStr = 'SELECT @Id_ProductoOUT = ISNULL(MAX(CI.Id_Producto),'''')'
	
	/*===================================================================*/
	
	SET @SqlStr = RTRIM(LTRIM(@SqlStr))																+ CHAR(13) + 
				' FROM Cbtes CB, Cbtes_Items CI, Cbtes_Tipos CT, Productos PR'
	
	/*===================================================================*/
	
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))															+ CHAR(13) + 
					' WHERE'																		+ CHAR(13) + 
					' CB.Id_Trans = CI.Id_Trans'													+ CHAR(13) +
					' AND ISNULL(CB.Id_Tipo_Cbte, '''') = CT.Id_Tipo_Cbte'							+ CHAR(13) +
					' AND ISNULL(CI.Id_Producto, '''') = PR.Id_Producto'							+ CHAR(13) +
					' AND CI.Id_Cliente = '+ CAST(@pId_Cliente AS VARCHAR(10))						+ CHAR(13) +
					' AND LTRIM(RTRIM(ISNULL(CI.Id_Producto, ''''))) IN (' + @Lista_Id_Productos + ')'
	
	/*===================================================================*/
	
	SET @SqlStr =	RTRIM(LTRIM(@SqlStr))															+ CHAR(13) + 
					' AND ISNULL(CT.Compromete_Factura, 0) IN (1)'									+ CHAR(13) + 
					' AND ((ISNULL(CB.Id_Estado_Cbte, 0) = 2) OR (ISNULL(CB.Id_Estado_Cbte, 0) IN (1, 4) AND ISNULL(CI.Imp_Final, 0) = 0))'

	/*===================================================================*/
	
	--No controla ni mes ni periodo, con que alguna vez lo haya pagado esta ok
	SET @SqlStrNotNull =	RTRIM(LTRIM(@SqlStr))													+ CHAR(13) + 
							' AND ISNULL(PR.Flag_Mes, 0) = 0'										+ CHAR(13) +  
							' AND ISNULL(PR.Flag_Periodo, 0) = 0'
	IF(@pModoDebug = 1)
	BEGIN
		PRINT ''
		PRINT 'No controla ni mes ni periodo, con que alguna vez lo haya pagado esta ok'
		PRINT @SqlStrNotNull
	END
	
	EXECUTE sp_executesql @SqlStrNotNull, @Parametros, @Id_ProductoOUT = @Id_Producto OUTPUT;
	IF (@Id_Producto <> '')
	BEGIN
		SET @Flag_Item_Pagado = 1
	END
	
	/*===================================================================*/

	IF (@Flag_Item_Pagado = 0) --Hasta ahora no encontr ningun producto que cumpla alguna de las condiciones anteriores, cambia la condicion y vuelve a evaluar
	BEGIN
		--Controla mes
		SET @SqlStrNotNull =	RTRIM(LTRIM(@SqlStr))												+ CHAR(13) + 
							' AND ISNULL(PR.Flag_Mes, 0) = 1'										+ CHAR(13) +  
							--' AND ISNULL(PR.Flag_Periodo, 0) = 0' (Con que este tildado mes no importa periodo porque tiene prioridad por sobre periodo)
							' AND dbo.CF_FOMONTH(CONVERT(DATE, ISNULL(CI.Fecha_QA, ''19000101''))) = dbo.CF_FOMONTH(CONVERT(DATE, ''' + @Fecha_DATE_VARCHAR + '''))'
		IF(@pModoDebug = 1)
		BEGIN
			PRINT @SqlStrNotNull
		END
		
		EXECUTE sp_executesql @SqlStrNotNull, @Parametros, @Id_ProductoOUT = @Id_Producto OUTPUT;
		IF (@Id_Producto <> '')
		BEGIN
			PRINT ''
			PRINT 'Controla Mes'
			SET @Flag_Item_Pagado = 1			
		END
	END


	/*===================================================================*/	
	
	IF (@Flag_Item_Pagado = 0) --Hasta ahora no encontr ningun producto que cumpla alguna de las condiciones anteriores, cambia la condicion y vuelve a evaluar
	BEGIN
		--Controla Periodo
		SET @SqlStrNotNull =	RTRIM(LTRIM(@SqlStr))												+ CHAR(13) + 
							' AND ISNULL(PR.Flag_Mes, 0) = 0'										+ CHAR(13) +  
							' AND ISNULL(PR.Flag_Periodo, 0) = 1'									+ CHAR(13) + 
							' AND CONVERT(DATE, ISNULL(CI.Fecha_QA, ''19000101'')) <= ''' +@Fecha_DATE_VARCHAR  + '''' + CHAR(13) + 
							' AND CONVERT(DATE, ISNULL(CI.Fecha_Venc, ''19000101'')) >= ''' + @Fecha_DATE_VARCHAR + '''' 
		IF(@pModoDebug = 1)
		BEGIN
			PRINT @SqlStrNotNull
		END
		
		EXECUTE sp_executesql @SqlStrNotNull, @Parametros, @Id_ProductoOUT = @Id_Producto OUTPUT;
		IF (@Id_Producto <> '')
		BEGIN
			PRINT ''
			PRINT 'Controla Periodo'
			SET @Flag_Item_Pagado = 1			
		END
	END
	
	/*===================================================================*/


	SET @rtaMsjStored		=	'{' +
								dbo.CF_Json_ParsearVariable('flag_paid', @Flag_Item_Pagado, 'TINYINT') +
								'}'


	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@rtaMsjStored	AS ErrorMessage

	IF(@pModoDebug = 1)
	BEGIN
		PRINT 'Fin Stored Procedure: CPJ_Item_Paid_On_Date'
	END

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo

	IF @pFlagUsarTrans <> 0 
	BEGIN
		ROLLBACK
	END

	RETURN 9999
END CATCH

RETURN 0 

/*
Ej.
DECLARE @pJson VARCHAR(8000)
SET @pJson =	'{' +
				dbo.CF_Json_ParsearVariable('ModoDebug', 1, 'TINYINT') + ',' +
				dbo.CF_Json_ParsearVariable('Id_Cliente', 2490, 'INT') + ',' +
				dbo.CF_Json_ParsearVariable('Fecha', GETDATE(), 'DATETIME') + 
				dbo.CF_Json_ParsearVariable('Id_Productos', 'CS101,CS102', 'VARCHAR(7900)') + 
				'}'
EXEC dbo.CPJ_Item_Paid_On_Date @pJson
*/